//
//  MCMainWindowBookmarkBar.h
//  MCApplication
//
//  Created by Ali Lalani on 9/7/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <MCFoundation/MCSourceList.h>

@class MCRolloverMenuButton,MCPDocument;

@interface MCMainWindowBookmarkBar : NSView {
	NSMutableArray *buttons;
	NSMutableArray *leftAuxiliaryButtons;
	
	NSString *userDefaultsKey;
	NSString *sourceListPasteboardType;
	
	NSAttributedString *placeholderString;
	NSDictionary *onDisplayAttributes;
	NSDictionary *offDisplayAttributes;
	MCRolloverMenuButton *excessButton;

	id draggedSourceList;
	NSInteger draggedIndex;
	float draggedWidth;
	NSTimer *buttonAnimationTimer;
	
	id parentController; // this will be in this case the window controller
	id document;
	NSWindow *mainWindow;	
}
/////////////////////////////////////// SETUP & VIEW CONFIGURATION //////////////////////////
- (id)initWithFrame:(NSRect)rect parentController:(id)aParentController userDefaultsKey:(NSString *)defKey document:(MCPDocument *)doc;
- (id)initWithFrame:(NSRect)rect parentController:(id)aParentController;

- (void)addButtonForSourceList:(id <MCSourceList>)sourceList atIndex:(unsigned int)index;
- (void)addLeftAuxiliaryButtonWithTarget:(id)aTarget action:(SEL)anAction image:(NSImage *)anImage pressedImage:(NSImage *)pressed;

- (void)updateButtonsForSourceLists:(NSArray *)sourceLists;
- (void)updateButtonsForCurrentSourceLists;
- (void)tile;
- (void)setupExcessButton;
- (void)configureMenuIfNeeded;
- (void)setTitleForButton:(MCRolloverMenuButton *)aButton index:(unsigned int)anIndex;
- (void)syncToDefaults;
- (void)syncFromDefaults;
- (void)resetTrackingRects;

///////////////////////////////////// ANIMATION ////////////////////////////////////////////
- (void)animateButtons;
- (void)buttonAnimationTimerActed:(NSTimer *)aTimer;

///////////////////////////////////// DRAG AND DROP ////////////////////////////////////////
- (NSDragOperation)draggingUpdatedAtLocation:(NSPoint)aPoint;

///////////////////////////////////// ACTION ///////////////////////////////////////////////
- (IBAction)bookmarkSelected:(id)sender;

//////////////////////////////////// CONVENIENCE ///////////////////////////////////////////
- (MCRolloverMenuButton *)lastVisibleSourceListButton;
- (MCRolloverMenuButton *)buttonForSourceList:(id <MCSourceList>)sourceList;
- (NSRect)drawableBounds;
- (void)selectButtonAtIndex:(unsigned int)index;

//////////////////////////////////// ACCESSORS /////////////////////////////////////////////
- (NSMutableArray *)buttons;
- (void)setButtons:(NSMutableArray *)aButtons;
- (NSMutableArray *)leftAuxiliaryButtons;
- (void)setLeftAuxiliaryButtons:(NSMutableArray *)aLeftAuxiliaryButtons;

- (NSString *)sourceListPasteboardType;
- (void)setSourceListPasteboardType:(NSString *)aSourceListPasteboardType;

// These determine what font, color, etc the display string of the button will be when there is no mouse over and when there is a mouse over/down
- (NSDictionary *)offDisplayAttributes;
- (void)setOffDisplayAttributes:(NSDictionary *)anOffDisplayAttributes;
- (NSDictionary *)onDisplayAttributes;
- (void)setOnDisplayAttributes:(NSDictionary *)anOnDisplayAttributes;

- (id)parentController;
- (void)setParentController:(id)aController;

- (NSString *)userDefaultsKey;
- (void)setUserDefaultsKey:(NSString *)anUserDefaultsKey;

- (MCPDocument *)document;
- (void)setDocument:(MCPDocument *)doc;

- (NSWindow *)mainWindow;
- (void)setMainWindow:(NSWindow *)aMainWindow;
@end
